<?php
/*
Plugin Name: uEmcee - Photo Sharing
Plugin URI: http://www.uemcee.com/uemcee/connect/wordpress-widget/
Description: Display photos from your uEmcee photo album onto your WordPress Blog.
Version: 2.0
Author: Joseph Tinsley
Author URI: http://www.uemcee.com/uemcee/
*/

class uemcee_widget extends WP_Widget
{

    function uemcee_widget(){
    $widget_ops = array('classname' => 'uemcee_photo_widget', 'description' => 'Display photos from your uEmcee photo gallery' );
    $control_ops = array('width' => 300, 'height' => 300);
    $this->WP_Widget('uemcee_widget', 'uEmcee Photo\'s', $widget_ops, $control_ops);
    }

function uemcee_Photo_XML($user_name) {

    $json_output = file_get_contents('http://www.uemcee.com/connect/api/getwp/'.$user_name.'/');

    $contents = utf8_encode($json_output);
    $results = json_decode($contents);
     
return $results;		
}

function widget($args, $instance) {

	extract($args);

	$title = $instance['title'];
	$user_name = $instance['user_name'];
	$display = $instance['display'];

	$photoDisplay = $this->uemcee_Photo_XML($user_name);

	echo $before_widget;

	if ( $user_name )

	echo "<h2 style=\"text-align:left;\"><a href=\"http://www.uemcee.com/".$user_name."\">". $title ."</a></h2>";
	for($c=0; $c < $display; $c++){  
	    echo "<span style=\"text-align:center;display:block;padding:2px;\">";        
	    echo "<a href=http://www.uemcee.com/".$user_name."/photo/".$photoDisplay[$c][0]."/"." title=\"".$photoDisplay[$c][2]."\">".
	    "<img src=\"http://www.uemcee.com/display/thumb/".$photoDisplay[$c][1]."\" border=\"0\" style=\"padding: 5px; border: 1px solid #aaa;\" alt=\"".$photoDisplay[$c][2]."\"></a>";
	    echo "</span>";            
	}
	 
	echo $after_widget;		
}


    function update($new_instance, $old_instance){
      $instance = $old_instance;
      $instance['user_name'] = strip_tags(stripslashes($new_instance['user_name']));
      $instance['title'] = strip_tags(stripslashes($new_instance['title']));
      $instance['display'] = strip_tags(stripslashes($new_instance['display']));

    return $instance;
  }

    function form($instance){

      $instance = wp_parse_args( (array) $instance, array('user_name'=>'Username', 'title'=>'Album Title', 'display'=>'3') );

      $user_name= htmlspecialchars($instance['user_name']);
      $title = htmlspecialchars($instance['title']);
      $display = htmlspecialchars($instance['display']);

?> 

<p style="text-align:right;">
<label for="<?php echo $this->get_field_name('title');?>">
<?php echo 'Title:'; ?> 
<input style="width: 150px;" id="<?php echo $this->get_field_id('title');?>" name="<?php echo $this->get_field_name('title');?>" type="text" value="<?php echo $title;?>" />
</label>
</p>
    
<p style="text-align:right;">
<label for="<?php echo $this->get_field_name('user_name');?>">
<?php echo 'http://uEmcee.com/'; ?> 
<input style="width: 150px;" id="<?php echo $this->get_field_id('user_name');?>" name="<?php echo $this->get_field_name('user_name');?>" type="text" value="<?php echo $user_name;?>" />
</label>
</p>


<p style="text-align:right;">
<label for="<?php echo $this->get_field_id( 'display' ); ?>">Images Displayed:</label>
<select id="<?php echo $this->get_field_id( 'display' ); ?>" name="<?php echo $this->get_field_name( 'display' ); ?>" style="width:150px;">
    <option <?php if ( '1' == $instance['display'] ) echo 'selected="selected"'; ?>>1</option>
    <option <?php if ( '2' == $instance['display'] ) echo 'selected="selected"'; ?>>2</option>
    <option <?php if ( '3' == $instance['display'] ) echo 'selected="selected"'; ?>>3</option>
    <option <?php if ( '4' == $instance['display'] ) echo 'selected="selected"'; ?>>4</option>
    <option <?php if ( '5' == $instance['display'] ) echo 'selected="selected"'; ?>>5</option>
</select>
</p>

<?
  }

}

  function uemcee_widget_Init() {
  register_widget('uemcee_widget');
  }
  
  add_action('widgets_init', 'uemcee_widget_Init');
?>
